//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

UiDefaultSlider {
    id : uiSlider

    property string resetLabel : qsTrId("f9330eba97fc373e")

    property bool indeterminate : false

    trackBaseColor : UiColors.getColor(UiColors.MediumGrey33)
    handleColor    : UiColors.getColor(UiColors.ButtonNormalBlue)
    handleOpacity  : indeterminate ? .5 : 1
    valueBarColor  : UiColors.getColor(UiColors.ButtonNormalBlue)

    states : [
        State {
            name : "disabled"
            when : !uiSlider.enabled

            PropertyChanges {
                target         : uiSlider
                trackBaseColor : UiColors.getColor(UiColors.DisabledLightGrey13)
                handleColor    : UiColors.getColor(UiColors.DisabledLightGrey13)
                valueBarColor  : UiColors.getColor(UiColors.DisabledLightGrey13)
            }
        },
        State {
            name : "pressed"
            when : uiSlider.pressed

            PropertyChanges {
                target        : uiSlider
                handleWidth   : 5
                handleColor   : UiColors.getColor(UiColors.ButtonPressBlue)
                valueBarColor : UiColors.getColor(UiColors.ButtonPressBlue)
            }
        },
        State {
            name : "hovered"
            when : uiSlider.hovered

            PropertyChanges {
                target        : uiSlider
                handleWidth   : 5
                handleColor   : UiColors.getColor(UiColors.ButtonHoverBlue)
                valueBarColor : UiColors.getColor(UiColors.ButtonHoverBlue)
            }
        }
    ]

    UiContextMenu {
        enabled   : !isNaN(uiSlider.resetValue)
        itemStyle : UiContextMenu.OnlyText
        items     : UiMenuItem {
            text        : uiSlider.resetLabel
            onTriggered : uiSlider.reset()
        }
    }

    Repeater {
        model : uiSlider.tickMarks || []

        delegate : Rectangle {
            color : uiSlider.trackBaseColor
            width : 2
            height : modelData.height

            x : uiSlider.margin + (uiSlider.width - uiSlider.margin * 3)
                * modelData.position - 1
            y : Math.floor(uiSlider.height / 2) - modelData.height / 2
            z : -1
        }
    }
}
